/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.controller;

import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.ColorInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.IntegerInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.action.Settings;
import de.willuhn.jameica.gui.internal.parts.CertificateList;
import de.willuhn.jameica.gui.internal.parts.PluginDetailPart;
import de.willuhn.jameica.gui.internal.parts.PluginListPart;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.messaging.PluginCacheMessageConsumer;
import de.willuhn.jameica.messaging.SettingsChangedMessage;
import de.willuhn.jameica.messaging.SettingsRestoredMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.SystrayService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BootstrapSettings;
import de.willuhn.jameica.system.Config;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SettingsControl
extends AbstractControl {
    private static final I18N i18n = Application.getI18n();
    private Input logLevel;
    private TextInput proxyHost;
    private TextInput httpsProxyHost;
    private IntegerInput proxyPort;
    private IntegerInput httpsProxyPort;
    private CheckboxInput systemProxy;
    private CheckboxInput askWorkDir;
    private SelectInput locale;
    private TablePart certs;
    private CheckboxInput trustJavaCerts;
    private Part plugins;
    private Input colorError;
    private Input colorSuccess;
    private Input colorMandatoryBG;
    private CheckboxInput mandatoryLabel;
    private CheckboxInput randomSplash;
    private CheckboxInput systray;
    private CheckboxInput minimizeToSystray;

    public SettingsControl(AbstractView view) {
        super(view);
    }

    public Input getLogLevel() {
        if (this.logLevel != null) {
            return this.logLevel;
        }
        Object[] levels = new String[]{Level.TRACE.getName(), Level.DEBUG.getName(), Level.INFO.getName(), Level.WARN.getName(), Level.ERROR.getName()};
        this.logLevel = new SelectInput(levels, (Object)Logger.getLevel().getName());
        return this.logLevel;
    }

    public Input getProxyHost() {
        if (this.proxyHost != null) {
            return this.proxyHost;
        }
        this.proxyHost = new TextInput(Application.getConfig().getProxyHost());
        this.proxyHost.setName(i18n.tr("HTTP-Proxy"));
        this.proxyHost.setHint("<" + i18n.tr("Hostname") + ">");
        return this.proxyHost;
    }

    public IntegerInput getProxyPort() {
        if (this.proxyPort != null) {
            return this.proxyPort;
        }
        this.proxyPort = new IntegerInput(Application.getConfig().getProxyPort());
        this.proxyPort.setMaxLength(5);
        this.proxyPort.setName("");
        this.proxyPort.setHint("<" + i18n.tr("TCP-Port") + ">");
        this.proxyPort.setComment(Application.getI18n().tr("freilassen, wenn nicht gew\u00fcnscht"));
        return this.proxyPort;
    }

    public TextInput getHttpsProxyHost() {
        if (this.httpsProxyHost != null) {
            return this.httpsProxyHost;
        }
        this.httpsProxyHost = new TextInput(Application.getConfig().getHttpsProxyHost());
        this.httpsProxyHost.setName(i18n.tr("HTTPS-Proxy"));
        this.httpsProxyHost.setHint("<" + i18n.tr("Hostname") + ">");
        return this.httpsProxyHost;
    }

    public IntegerInput getHttpsProxyPort() {
        if (this.httpsProxyPort != null) {
            return this.httpsProxyPort;
        }
        this.httpsProxyPort = new IntegerInput(Application.getConfig().getHttpsProxyPort());
        this.httpsProxyPort.setMaxLength(5);
        this.httpsProxyPort.setName("");
        this.httpsProxyPort.setHint("<" + i18n.tr("TCP-Port") + ">");
        this.httpsProxyPort.setComment(Application.getI18n().tr("freilassen, wenn nicht gew\u00fcnscht"));
        return this.httpsProxyPort;
    }

    public CheckboxInput getUseSystemProxy() {
        if (this.systemProxy == null) {
            this.systemProxy = new CheckboxInput(Application.getConfig().getUseSystemProxy());
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    try {
                        boolean value = (Boolean)SettingsControl.this.systemProxy.getValue();
                        SettingsControl.this.getProxyHost().setEnabled(!value);
                        SettingsControl.this.getProxyPort().setEnabled(!value);
                        SettingsControl.this.getHttpsProxyHost().setEnabled(!value);
                        SettingsControl.this.getHttpsProxyPort().setEnabled(!value);
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to apply settings", (Throwable)e);
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der Proxy-Einstellungen: {0}", e.getMessage()), 1));
                    }
                }
            };
            this.systemProxy.addListener(l);
            l.handleEvent(null);
        }
        return this.systemProxy;
    }

    public CheckboxInput getAskWorkdir() {
        if (this.askWorkDir == null) {
            this.askWorkDir = new CheckboxInput(BootstrapSettings.getAskWorkdir());
            this.askWorkDir.setName(i18n.tr("Zu verwendenden Benutzer-Ordner bei Start ausw\u00e4hlen"));
        }
        return this.askWorkDir;
    }

    public SelectInput getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        ArrayList<Locale> list = new ArrayList<Locale>();
        list.add(Locale.GERMANY);
        list.add(Locale.ENGLISH);
        Locale current = Application.getConfig().getLocale();
        Locale selected = Objects.equals(current.getLanguage(), Locale.ENGLISH.getLanguage()) ? Locale.ENGLISH : Locale.GERMAN;
        this.locale = new SelectInput(list, (Object)selected);
        this.locale.setAttribute("displayName");
        return this.locale;
    }

    public Part getCertificates() throws Exception {
        if (this.certs != null) {
            return this.certs;
        }
        this.certs = new CertificateList();
        return this.certs;
    }

    public CheckboxInput getTrustJavaCerts() {
        if (this.trustJavaCerts != null) {
            return this.trustJavaCerts;
        }
        this.trustJavaCerts = new CheckboxInput(Application.getConfig().getTrustJavaCerts());
        this.trustJavaCerts.setName(i18n.tr("Den Aussteller-Zertifikaten von Java vertrauen"));
        return this.trustJavaCerts;
    }

    public Part getPlugins() {
        if (this.plugins != null) {
            return this.plugins;
        }
        PluginDetailPart.Type t = PluginCacheMessageConsumer.getCache().size() > 0 ? PluginDetailPart.Type.INSTALLED : PluginDetailPart.Type.AVAILABLE;
        this.plugins = new PluginListPart(t);
        return this.plugins;
    }

    public Input getColorMandatoryBG() {
        if (this.colorMandatoryBG != null) {
            return this.colorMandatoryBG;
        }
        this.colorMandatoryBG = new ColorInput(de.willuhn.jameica.gui.util.Color.MANDATORY_BG.getSWTColor(), false);
        return this.colorMandatoryBG;
    }

    public Input getColorError() {
        if (this.colorError != null) {
            return this.colorError;
        }
        this.colorError = new ColorInput(de.willuhn.jameica.gui.util.Color.ERROR.getSWTColor(), true);
        return this.colorError;
    }

    public Input getColorSuccess() {
        if (this.colorSuccess != null) {
            return this.colorSuccess;
        }
        this.colorSuccess = new ColorInput(de.willuhn.jameica.gui.util.Color.SUCCESS.getSWTColor(), true);
        return this.colorSuccess;
    }

    public Input getMinimizeToSystray() {
        if (this.minimizeToSystray != null) {
            return this.minimizeToSystray;
        }
        SystrayService service = (SystrayService)Application.getBootLoader().getBootable(SystrayService.class);
        this.minimizeToSystray = new CheckboxInput(service.isMinimizeToSystray());
        this.minimizeToSystray.setName(i18n.tr("Fenster beim Minimieren/Schlie\u00dfen in System-Tray verschieben"));
        return this.minimizeToSystray;
    }

    public Input getSystray() {
        if (this.systray != null) {
            return this.systray;
        }
        SystrayService service = (SystrayService)Application.getBootLoader().getBootable(SystrayService.class);
        this.systray = new CheckboxInput(service.isEnabled());
        this.systray.setName(i18n.tr("Symbol im System-Tray anzeigen"));
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                boolean enabled = (Boolean)SettingsControl.this.systray.getValue();
                SettingsControl.this.getMinimizeToSystray().setEnabled(enabled);
            }
        };
        this.systray.addListener(l);
        l.handleEvent(null);
        return this.systray;
    }

    public CheckboxInput getLabelMandatory() {
        if (this.mandatoryLabel != null) {
            return this.mandatoryLabel;
        }
        this.mandatoryLabel = new CheckboxInput(Application.getConfig().getMandatoryLabel());
        return this.mandatoryLabel;
    }

    public CheckboxInput getRandomSplash() {
        if (this.randomSplash != null) {
            return this.randomSplash;
        }
        this.randomSplash = new CheckboxInput(Customizing.SETTINGS.getBoolean("application.splashscreen.random", false));
        return this.randomSplash;
    }

    public void handleStore() {
        try {
            Config config = Application.getConfig();
            boolean restartNeeded = false;
            config.setLoglevel((String)this.getLogLevel().getValue());
            BootstrapSettings.setAskWorkdir((Boolean)this.getAskWorkdir().getValue());
            Locale l = (Locale)this.getLocale().getValue();
            restartNeeded |= !Application.getConfig().getLocale().equals(l);
            config.setLocale(l);
            restartNeeded |= this.getProxyPort().hasChanged();
            Integer proxyPort = (Integer)this.getProxyPort().getValue();
            config.setProxyPort(proxyPort == null ? -1 : proxyPort);
            restartNeeded |= this.getProxyHost().hasChanged();
            config.setProxyHost((String)this.getProxyHost().getValue());
            restartNeeded |= this.getHttpsProxyPort().hasChanged();
            proxyPort = (Integer)this.getHttpsProxyPort().getValue();
            config.setHttpsProxyPort(proxyPort == null ? -1 : proxyPort);
            restartNeeded |= this.getHttpsProxyHost().hasChanged();
            config.setHttpsProxyHost((String)this.getHttpsProxyHost().getValue());
            restartNeeded |= this.getUseSystemProxy().hasChanged();
            config.setUseSystemProxy((Boolean)this.getUseSystemProxy().getValue());
            restartNeeded |= this.getTrustJavaCerts().hasChanged();
            config.setTrustJavaCerts((Boolean)this.getTrustJavaCerts().getValue());
            config.setMandatoryLabel((Boolean)this.getLabelMandatory().getValue());
            Customizing.SETTINGS.setAttribute("application.splashscreen.random", (Boolean)this.getRandomSplash().getValue());
            de.willuhn.jameica.gui.util.Color.ERROR.setSWTColor((Color)this.getColorError().getValue());
            de.willuhn.jameica.gui.util.Color.SUCCESS.setSWTColor((Color)this.getColorSuccess().getValue());
            de.willuhn.jameica.gui.util.Color.MANDATORY_BG.setSWTColor((Color)this.getColorMandatoryBG().getValue());
            SystrayService systray = (SystrayService)Application.getBootLoader().getBootable(SystrayService.class);
            systray.setEnabled((Boolean)this.getSystray().getValue());
            systray.setMinimizeToSystray((Boolean)this.getMinimizeToSystray().getValue());
            Application.getMessagingFactory().sendSyncMessage(new SettingsChangedMessage());
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Einstellungen gespeichert."), 0));
            if (restartNeeded) {
                Application.getCallback().notifyUser(i18n.tr("Bitte starten Sie Jameica neu, damit alle \u00c4nderungen wirksam werden."));
            }
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while writing config", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Speichern der Einstellungen."), 1));
        }
    }

    public void handleRestore() {
        try {
            YesNoDialog prompt = new YesNoDialog(1);
            prompt.setTitle(i18n.tr("Sicher?"));
            prompt.setText(i18n.tr("Alle Einstellungen werden auf die Standard-Werte zur\u00fcckgesetzt"));
            if (!((Boolean)prompt.open()).booleanValue()) {
                return;
            }
            de.willuhn.jameica.gui.util.Color.COMMENT.reset();
            de.willuhn.jameica.gui.util.Color.ERROR.reset();
            de.willuhn.jameica.gui.util.Color.SUCCESS.reset();
            de.willuhn.jameica.gui.util.Color.LINK.reset();
            de.willuhn.jameica.gui.util.Color.LINK_ACTIVE.reset();
            Application.getConfig().setRmiPort(4840);
            Application.getConfig().setLoglevel(Level.INFO.getName());
            Application.getConfig().setRmiSSL(true);
            Application.getConfig().setProxyHost(null);
            Application.getConfig().setProxyPort(-1);
            Application.getMessagingFactory().sendSyncMessage(new SettingsRestoredMessage());
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Einstellungen zur\u00fcckgesetzt."), 0));
            new Settings().handleAction(null);
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (Exception e) {
            Logger.error((String)"error while restoring settings", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Zur\u00fccksetzen der Einstellungen."), 1));
        }
    }
}

